/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.skills.transaction;

import dev.toma.gunsrpg.api.common.ITransaction;
import dev.toma.gunsrpg.api.common.ITransactionType;
import dev.toma.gunsrpg.common.item.guns.GunItem;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import dev.toma.gunsrpg.common.skills.transaction.TransactionTypes;

public class WeaponPointTransaction
implements ITransaction<IWeaponData> {
    private final IWeaponData data;

    public WeaponPointTransaction(IWeaponData data) {
        this.data = data;
    }

    @Override
    public int total() {
        return this.data.skill().getProperties().getPrice();
    }

    @Override
    public IWeaponData getData() {
        return this.data;
    }

    @Override
    public ITransactionType<IWeaponData> getType() {
        return TransactionTypes.WEAPON_POINT_TRANSACTION;
    }

    public static interface IWeaponData {
        public GunItem item();

        public SkillType<?> skill();

        public static IWeaponData of(final GunItem item, final SkillType<?> skill) {
            return new IWeaponData(){

                @Override
                public GunItem item() {
                    return item;
                }

                @Override
                public SkillType<?> skill() {
                    return skill;
                }
            };
        }
    }
}

